#include "offsets.h"
#include "math.hpp"

namespace camera
{
	FVector location, rotation;
	float fov;
}

struct camera_position_s {
	FVector location{};
	FVector rotation{};
	float fov{};
};
inline camera_position_s camera_postion{};

class entity {
public:
	uintptr_t
		actor,
		skeletal_mesh,
		root_component,
		player_state;
	int
		team_index;
};

class Pointers {
public:
	uintptr_t
		uworld,
		game_instance,
		game_state,
		local_player,
		acknowledged_pawn,
		player_state,
		player_controller,
		root_component,
		skeletal_mesh,
		persistent_level,
		world_settings,
		WorldGravityZ,
		player_array,
		entity_array,
		mesh,
		current_actor,
		levels,

		player_array_size,
		current_weapon,
		current_vehicle;
	int
		team_index;
	FVector
		relative_location;

	Vector3
		LocalRelativeLocation;
}; static Pointers* pointer = new Pointers();

FVector Prediction(FVector TargetPosition, FVector ComponentVelocity, float player_distance, float ProjectileSpeed = 239)
{
	float gravity = 3.5;
	float TimeToTarget = player_distance / ProjectileSpeed;
	float bulletDrop = abs(gravity) * (TimeToTarget * TimeToTarget) * 0.5;
	return FVector
	{
		TargetPosition.x + TimeToTarget * ComponentVelocity.x,
		TargetPosition.y + TimeToTarget * ComponentVelocity.y,
		TargetPosition.z + TimeToTarget * ComponentVelocity.z + bulletDrop
	};
}

auto IsVisible(uintptr_t skeletal_mesh) -> bool {
	SPOOF_FUNC;
	auto last_submit = read<float>(skeletal_mesh + offsets::fLastSubmitTime);
	auto last_render = read<float>(skeletal_mesh + offsets::fLastRenderTimeOnScreen);
	const float fVisionTick = 0.06f;
	bool visible = last_render + fVisionTick >= last_submit;
	return visible;
}

static auto GetBoneLocation(uintptr_t skeletal_mesh, int bone_index) -> FVector {
	SPOOF_FUNC;
	uintptr_t bone_array = read<uintptr_t>(skeletal_mesh + offsets::BoneArray);
	if (bone_array == NULL) bone_array = read<uintptr_t>(skeletal_mesh + offsets::BoneArray + 0x10);
	ftransform bone = read<ftransform>(bone_array + (bone_index * 0x60));
	ftransform component_to_world = read<ftransform>(skeletal_mesh + offsets::ComponentToWorld);
	D3DMATRIX matrix = MatrixMultiplication(bone.ToMatrixWithScale(), component_to_world.ToMatrixWithScale());
	return FVector(matrix._41, matrix._42, matrix._43);
}

static auto WorldToScreen(FVector worldlocation) -> FVector2d {
	D3DMATRIX tempMatrix = Matrix(camera::rotation);

	FVector vAxisX = FVector(tempMatrix.m[0][0], tempMatrix.m[0][1], tempMatrix.m[0][2]);
	FVector vAxisY = FVector(tempMatrix.m[1][0], tempMatrix.m[1][1], tempMatrix.m[1][2]);
	FVector vAxisZ = FVector(tempMatrix.m[2][0], tempMatrix.m[2][1], tempMatrix.m[2][2]);

	FVector vDelta = worldlocation - camera::location;
	FVector vTransformed = FVector(vDelta.Dot(vAxisY), vDelta.Dot(vAxisZ), vDelta.Dot(vAxisX));

	if (vTransformed.z < 1.f)
		vTransformed.z = 1.f;
	return FVector2d((GetSystemMetrics(SM_CXSCREEN) / 2.0f) + vTransformed.x * (((GetSystemMetrics(SM_CXSCREEN) / 2.0f) / tanf(camera::fov * (float)M_PI / 360.f))) / vTransformed.z, (GetSystemMetrics(SM_CYSCREEN) / 2.0f) - vTransformed.y * (((GetSystemMetrics(SM_CXSCREEN) / 2.0f) / tanf(camera::fov * (float)M_PI / 360.f))) / vTransformed.z);
}

auto InScreen(FVector2d screen_position) -> bool {
	if (screen_position.x > 0 && screen_position.x < GetSystemMetrics(SM_CXSCREEN) && screen_position.y > 0 && screen_position.y < GetSystemMetrics(SM_CYSCREEN))
		return true;
	else
		return false;
}

static auto UpdateCamera() -> void
{
	SPOOF_FUNC;
	auto location_pointer = read<uintptr_t>(pointer->uworld + 0x110);
	auto rotation_pointer = read<uintptr_t>(pointer->uworld + 0x120);

	struct FNRotation
	{
		double a;
		char pad_0008[24];
		double b;
		char pad_0028[424];
		double c;
	}tpmrotation;

	tpmrotation.a = read<double>(rotation_pointer);
	tpmrotation.b = read<double>(rotation_pointer + 0x20);
	tpmrotation.c = read<double>(rotation_pointer + 0x1d0);

	camera::rotation.x = asin(tpmrotation.c) * (180.0 / M_PI);
	camera::rotation.y = ((atan2(tpmrotation.a * -1, tpmrotation.b) * (180.0 / M_PI)) * -1) * -1;
	camera::rotation.z = 0;
	camera::location = read<FVector>(location_pointer);
	camera::fov = read<float>(pointer->player_controller + 0x394) * 90.f;
}

ftransform GetBoneIndex(uint64_t mesh, int index)
{
	SPOOF_FUNC;
	uint64_t bonearray = read<uint64_t>(mesh + 0x4a8);
	if (!bonearray) bonearray = read<uint64_t>(mesh + 0x4a8 + 0x10);
	return read<ftransform>(bonearray + (index * 0x30));
}

Vector3 GetBoneWithRotation(DWORD_PTR mesh, int id)
{
	SPOOF_FUNC;
	ftransform bone = GetBoneIndex(mesh, id);
	ftransform ComponentToWorld = read<ftransform>(mesh + 0x1c0);

	D3DMATRIX Matrix;
	Matrix = MatrixMultiplication(bone.ToMatrixWithScale(), ComponentToWorld.ToMatrixWithScale());

	return Vector3(Matrix._41, Matrix._42, Matrix._43);
}

FVector GetBoneWithRotation2(DWORD_PTR mesh, int id)
{
	SPOOF_FUNC;
	ftransform bone = GetBoneIndex(mesh, id);
	ftransform ComponentToWorld = read<ftransform>(mesh + 0x1c0);

	D3DMATRIX Matrix;
	Matrix = MatrixMultiplication(bone.ToMatrixWithScale(), ComponentToWorld.ToMatrixWithScale());

	return FVector(Matrix._41, Matrix._42, Matrix._43);
}

struct cdecrypt
{
	Vector3 location;
	Vector3 rotation;
	float fov;
};

__forceinline auto viewpoint() -> cdecrypt
{
	SPOOF_FUNC;
	uintptr_t cachedgworld = read<uintptr_t>(virtualaddy + offsets::UWorld);
	uintptr_t cachedgameinstance = read<uintptr_t>(cachedgworld + offsets::OwningGameInstance);
	uintptr_t cachedlocalplayers = read<uintptr_t>(cachedgameinstance + offsets::LocalPlayers);
	uintptr_t cachedlocalplayer = read<uintptr_t>(cachedlocalplayers);
	uintptr_t cachedplayercontroller = read<uintptr_t>(cachedlocalplayer + offsets::PlayerController);

	cdecrypt camera;

	auto locationp = read<uintptr_t>(cachedgworld + 0x110);
	auto rotationp = read<uintptr_t>(cachedgworld + 0x120);

	struct fnrotation
	{
		double a;
		double b;
		double c;
	}fnrotation;

	fnrotation.a = read<double>(rotationp);
	fnrotation.b = read<double>(rotationp + 0x20);
	fnrotation.c = read<double>(rotationp + 0x1d0);

	camera.location = read<Vector3>(locationp);
	camera.rotation.x = asin(fnrotation.c) * (180.0 / M_PI);
	camera.rotation.y = ((atan2(fnrotation.a * -1, fnrotation.b) * (180.0 / M_PI)) * -1) * -1;
	camera.fov = read<float>((uintptr_t)cachedplayercontroller + 0x394) * 90.f;

	return camera;
}

__forceinline auto matrix(Vector3 rotation, Vector3 origin = Vector3(0, 0, 0)) -> D3DXMATRIX
{
	double radPitch = (rotation.x * double(M_PI) / 180.f);
	double radYaw = (rotation.y * double(M_PI) / 180.f);
	double radRoll = (rotation.z * double(M_PI) / 180.f);

	double SP = sinf(radPitch);
	double CP = cosf(radPitch);
	double SY = sinf(radYaw);
	double CY = cosf(radYaw);
	double SR = sinf(radRoll);
	double CR = cosf(radRoll);

	D3DMATRIX matrix;
	matrix.m[0][0] = CP * CY;
	matrix.m[0][1] = CP * SY;
	matrix.m[0][2] = SP;
	matrix.m[0][3] = 0.f;

	matrix.m[1][0] = SR * SP * CY - CR * SY;
	matrix.m[1][1] = SR * SP * SY + CR * CY;
	matrix.m[1][2] = -SR * CP;
	matrix.m[1][3] = 0.f;

	matrix.m[2][0] = -(CR * SP * CY + SR * SY);
	matrix.m[2][1] = CY * SR - CR * SP * SY;
	matrix.m[2][2] = CR * CP;
	matrix.m[2][3] = 0.f;

	matrix.m[3][0] = origin.x;
	matrix.m[3][1] = origin.y;
	matrix.m[3][2] = origin.z;
	matrix.m[3][3] = 1.f;

	return matrix;
}

__forceinline auto WorldToScreen2(Vector3 WorldLocation) -> Vector2
{
	SPOOF_FUNC;
	cdecrypt ViewPoint = viewpoint();
	D3DMATRIX MatrixT = matrix(ViewPoint.rotation);
	Vector3 AxisX = Vector3(MatrixT.m[0][0], MatrixT.m[0][1], MatrixT.m[0][2]);
	Vector3 AxisY = Vector3(MatrixT.m[1][0], MatrixT.m[1][1], MatrixT.m[1][2]);
	Vector3 AxisZ = Vector3(MatrixT.m[2][0], MatrixT.m[2][1], MatrixT.m[2][2]);
	Vector3 Delta = WorldLocation - ViewPoint.location;
	Vector3 Transformed = Vector3(Delta.Dot(AxisY), Delta.Dot(AxisZ), Delta.Dot(AxisX));
	if (Transformed.z < 1.f)
	{
		Transformed.z = 1.f;
	}

	return Vector2((GetSystemMetrics(SM_CXSCREEN) / 2.0f) + Transformed.x * (((GetSystemMetrics(SM_CXSCREEN) / 2.0f) / tanf(ViewPoint.fov * (float)M_PI / 360.f))) / Transformed.z, (GetSystemMetrics(SM_CYSCREEN) / 2.0f) - Transformed.y * (((GetSystemMetrics(SM_CXSCREEN) / 2.0f) / tanf(ViewPoint.fov * (float)M_PI / 360.f))) / Transformed.z);
}